#!/usr/bin/perl
#
#           RiLax 0.1.03
#
# plain text database search engine, 
# version 0.1
# (c) Sergej Tarasov, 2001
#
# Homepage: http://risearch.org/
# email: risearch@risearch.org
# Last modified: 17.02.2002



#===================================================================
#
#         Bearbeiten Sie die folgenden Variablen 
#
#===================================================================

# Datenbank Dateiname der zu verwendenden und zu indexierenden Datei
$DB_NAME = 'daten.txt';

# Zeilentrenner der Datensatzzeilen ("\n" fuer neue Zeile).
$record_separator = "\n";

# Datensatzfeldtrenner 
$field_separator  = "|";

# Welche Felder des Datensatzes sollen indexiert werden?
# Haben Sie einen Datensatz mit 5 Feldern so beginnt die Zaehlung bei 0
# Ist der erste Datensatz z.B. eine Zeilennummer schreiben Sie so:
# 1 2 3 4
# Das erste Feld mit den Zeilennummern wird dann nicht indexiert
@index_fileds     = qw(1 2 3 4);

# Datenbankdateigroesse
# 1 - Tiny    ~1Mb
# 2 - Medium  ~10Mb
# 3 - Big     ~50Mb
# 4 - Large   >100Mb
$site_size = 1;

# Suchbegriffe in Logstatistik schreiben? ("YES" oder "NO")
# Diese werden dann in das Verzeichnis logs gespeichert
# Das Verzeichnis logs muss angelegt sein und sollte CHMOD 777 besitzen
# Editieren Sie weitere Parameter in  der "stat.pl"
$create_log = "NO";

# Pfad zu Datenbank Index Dateien, kann im Regelfall so bleiben
$HASH      = "db/0_hash";
$HASHWORDS = "db/0_hashwords";
$SITEWORDS = "db/0_sitewords";
$WORD_IND  = "db/0_word_ind";

#===================================================================
#
#     Die folgenden Parameter muessen nicht unbedingt geaendert werden
#  
#     Diese Werde sind fuer den Index Prozess zustaendig
#
#===================================================================

# Minimale Wortlaenge die indexiert wird
$min_length = 3;

# Zahlen indexieren oder nicht? (setzen Sie   $numbers = ""   wenn Zahlen nicht indexiert werden sollen)
# Sie koennen hier auch weitere nicht Buchstaben und oder Zahlen Zeichen notieren
$numbers = '0-9';

# Index Schema
# Ganzes Wort - 1
# Beginn eines Wortes - 2
# Jede Teilzeichenkette - 3
$INDEXING_SCHEME = 2;

# Escape Zeichen uebersetzen (z.B. &Egrave; oder &#255;) ("YES" oder "NO")
$use_esc = "YES";

# Liste der Stopworte ("YES" oder "NO")
# Die hier notierten Englischen Worte waeren im Deutschen z.B.
# der die das er sie es usw...
$use_stop_words = "YES";
@stop_words = qw(
and any are but can had has have her here him his
how its not our out per she some than that the their them then there
these they was were what you
);

#===================================================================
#
#     Scriptausgabe
#
#===================================================================

# Anzahl der Resultate pro Seite
$res_num=10;


#===================================================================
#
#   Die Nachfolgenden Daten brauchen normalerweise nicht geaendert werden
#   Mit den Einstellungen koennen Sie mit den meisten Sprachen
#   Englisch, Russisch (win1251 encoding) und den meisten Europaeischen
#   Sprachen arbeiten.
#
#===================================================================

# Grossbuchstaben
$CAP_LETTERS = '\xC0-\xDF\xA8';

# Kleinbuchstaben
$LOW_LETTERS = '\xE0-\xFF\xB8';

# Wenn Sie Unicode Zeichen benutzen im Datensatz in der Form
# &#NNNN; ( NNNN>255), entfernen Sie das Kommentarzeichen und editieren
# die Zeilen unterhalb

%code2char = (
# 1040 => "",
# 1041 => "",
# 1042 => "",
# 1043 => "",
);

#===================================================================
#
#            --- Ende der Konfiguration --- 
#
# Bearbeiten Sie den  weiteren Code nur wenn Sie wissen was Sie tun!
#
#===================================================================

if ($site_size == 1) { $HASHSIZE = 20001 }
elsif ($site_size == 3) { $HASHSIZE = 100001 }
elsif ($site_size == 4) { $HASHSIZE = 300001 }
else { $HASHSIZE = 50001 }

$field_separator =~ s/([|(){}*?\\\[\]])/\\$1/g;

#===================================================================

sub hash {
    my ($key) = @_;
    my @chars = unpack("C*", $key);
    my $h = 0x00000000;
    my $f = 0xF0000000;
    foreach $char (@chars) {
        $h = ($h << 4) + $char;
        if ($g = $h & $f) { $h ^= $g >> 24 };
        $h &= ~$g;
    }
    $h =  $h % $HASHSIZE;
    return $h
}
#===================================================================

%stop_words = ();
if ($use_stop_words eq "YES") {
    foreach $word (@stop_words) { $stop_words{$word} = "" }
}
#=====================================================================

if ($use_esc eq "YES") { &html_esc() }

sub html_esc {
    %html_esc = (
        "&Agrave;" => chr(192),
        "&Aacute;" => chr(193),
        "&Acirc;" => chr(194),
        "&Atilde;" => chr(195),
        "&Auml;" => chr(196),
        "&Aring;" => chr(197),
        "&AElig;" => chr(198),
        "&Ccedil;" => chr(199),
        "&Egrave;" => chr(200),
        "&Eacute;" => chr(201),
        "&Eirc;" => chr(202),
        "&Euml;" => chr(203),
        "&Igrave;" => chr(204),
        "&Iacute;" => chr(205),
        "&Icirc;" => chr(206),
        "&Iuml;" => chr(207),
        "&ETH;" => chr(208),
        "&Ntilde;" => chr(209),
        "&Ograve;" => chr(210),
        "&Oacute;" => chr(211),
        "&Ocirc;" => chr(212),
        "&Otilde;" => chr(213),
        "&Ouml;" => chr(214),
        "&times;" => chr(215),
        "&Oslash;" => chr(216),
        "&Ugrave;" => chr(217),
        "&Uacute;" => chr(218),
        "&Ucirc;" => chr(219),
        "&Uuml;" => chr(220),
        "&Yacute;" => chr(221),
        "&THORN;" => chr(222),
        "&szlig;" => chr(223),
        "&agrave;" => chr(224),
        "&aacute;" => chr(225),
        "&acirc;" => chr(226),
        "&atilde;" => chr(227),
        "&auml;" => chr(228),
        "&aring;" => chr(229),
        "&aelig;" => chr(230),
        "&ccedil;" => chr(231),
        "&egrave;" => chr(232),
        "&eacute;" => chr(233),
        "&ecirc;" => chr(234),
        "&euml;" => chr(235),
        "&igrave;" => chr(236),
        "&iacute;" => chr(237),
        "&icirc;" => chr(238),
        "&iuml;" => chr(239),
        "&eth;" => chr(240),
        "&ntilde;" => chr(241),
        "&ograve;" => chr(242),
        "&oacute;" => chr(243),
        "&ocirc;" => chr(244),
        "&otilde;" => chr(245),
        "&ouml;" => chr(246),
        "&divide;" => chr(247),
        "&oslash;" => chr(248),
        "&ugrave;" => chr(249),
        "&uacute;" => chr(250),
        "&ucirc;" => chr(251),
        "&uuml;" => chr(252),
        "&yacute;" => chr(253),
        "&thorn;" => chr(254),
        "&yuml;" => chr(255),
        "&nbsp;" => " ",
        "&amp;" => " ",
        "&quote;" => " ",
    );

}
#=====================================================================

sub esc2char {
    my ($esc) = @_;
    my $char = "";
    if ($esc =~ /&[a-zA-Z]*;/) { $char = $html_esc{$esc} }
    elsif ($esc =~ /&#([0-9]*);/) {
    	if ($1 <= 255) { $char = chr($1) }
    	else { $char = $code2char{$1} }
    } elsif ($esc =~ /&#x([0-9a-fA-F]*);/i) {
    	my $code = hex($1);
    	if ($code <= 255) { $char = chr($code) }
    	else { $char = $code2char{$code} }
    }	
    return $char;
}
#=====================================================================



1;